package abstraction;
/**
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.3 09/04/10
 * @since JDK 1.6
 */

import java.util.*;
/**
 * This class manages a only read Iterator where remove operation is forbidden 
 */
public class OnlyReadIterator<T> implements Iterator<T> {
	
	private Iterator<T> i;
	
	public OnlyReadIterator(Iterator<T> it) {
		i = it;
	}
	
	public T next() { 
		return i.next(); 
	}
	
	public boolean hasNext() { 
		return i.hasNext(); 
	}
	
	public void remove() {
		throw new UnsupportedOperationException();
	}
}
	
	






